// JUnit Assert framework can be used for verification

import net.sf.sahi.client.Browser;

import org.springframework.beans.factory.annotation.Autowired;

import com.thoughtworks.twist.core.execution.TwistScenarioDataStore;

public class Workflow {

	private Browser browser;

	//@Autowired
	private TwistScenarioDataStore scenarioStore;

	public Workflow(Browser browser) {
		this.browser = browser;
	}

	public void selectWorkorder() throws Exception {
		String[] cellVal = {"FORTYSIX, PATIENT"};
		browser.cell(cellVal).click();
	
	}

	public void enterProtocol() throws Exception {
		String[] protocolVal = {"protocol1_nm"};
		browser.select(protocolVal).choose("CT HEAD Non-Contrast (axial)");
		}

	
	public void enterAllergy() throws Exception {
		String[] radioAllergySelect = {"edit-allergy-cd-no--2"};
		browser.radio(radioAllergySelect).click();
	
	}

	public void enterClaustrophobic() throws Exception {
		String[] radioClausSelect  = {"edit-claustrophobic-cd-no--2"};
		browser.radio(radioClausSelect).click();
	
	}

	public void enterNotes() throws Exception {
		String[] linkVal = {"Mass Markers"};
		browser.link(linkVal).click();
	}

	public void acknowledge() throws Exception {
		String[] checkboxVal1 = {"ci_responses[Age risk][chk_ack]"};
		String[] checkboxVal2 = {"ci_responses[Duplicate order risk][chk_ack]"};
		browser.checkbox(checkboxVal1).click();
		browser.checkbox(checkboxVal2).click();
	
	}

	public void releaseBackToWorklistWithouSaving() throws Exception {
    String[] submitVal = {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkorder1() throws Exception {
    String[] cellVal = {"ONEZEROONEONEONENINE, PATIENT[1]"};
		browser.cell(cellVal).click();
	
	}

	public void enterProtocolName() throws Exception {
    String[] selectVal = {"protocol1_nm"};
    browser.select(selectVal).choose("CT HEAD ANGIOGRAPHY (CTA) Ð ANEURYSM with and without Contrast (axial & helical)");
	}

	public void selectWorkorderFromTheList() throws Exception {
    String[] cellVal = {"ONEZEROONEONEONESEVEN, PATIENT"};
		browser.cell(cellVal).click();
	
	}

	public void selectProtocolName() throws Exception {
		String[] selectVal = {"protocol1_nm"};
		browser.select(selectVal).choose("CT HEAD ANGIOGRAPHY (CTA) Ð ANEURYSM with and without Contrast (axial & helical)");
	}

	public void selectAllergy() throws Exception {
    String[] radioVal = {"edit-allergy-cd-no--2"};
		browser.radio(radioVal).click();
	
	}

	public void selectClaustrophobic() throws Exception {
    String[] radioVal= {"edit-claustrophobic-cd-no--2"};
		browser.radio(radioVal).click();
	
	}

	public void enterNotesFromTheTabs() throws Exception {
    String[] linkVal= {"Mass Markers"};
		browser.link(linkVal).click();
	
	}

	public void acknowledgeTheOrder() throws Exception {
		String[] checkboxVal1 = {"ci_responses[Age risk][chk_ack]"};
		String[] checkboxVal2 = {"ci_responses[Duplicate order risk][chk_ack]"};
		browser.checkbox(checkboxVal2).click();
		browser.checkbox(checkboxVal1).click();
	
	
	}

	public void releaseBackToWorklistWithouSavingTheOrder() throws Exception {
    String[] submitVal = {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkorderFromTheListInRAPTOR() throws Exception {
    String[] cellVal = {"CT SCAN"};;
		browser.cell(cellVal).click();
		Thread.sleep(3000);
	
	}

	public void selectProtocolNameFromTheDropdown() throws Exception {
    String[] selectVal = {"protocol1_nm"};
    browser.select(selectVal).choose("CT HEAD ANGIOGRAPHY (CTA) Ð ANEURYSM with and without Contrast (axial & helical)");
	}
	
	
	public void selectAllergyRadioButton() throws Exception {
    String[] radioVal = {"edit-allergy-cd-no--2"};
		browser.radio(radioVal).click();
	}

	public void selectClaustrophobicRadioButton() throws Exception {
    String[] divVal= {"No[2]"};
    String[] radioVal={"edit-claustrophobic-cd-no--2"};
		browser.div(divVal).click();
		browser.radio(radioVal).click();
	
	}

	public void enterNotesFromTheTabsInTheList() throws Exception {
    String[] linkVal= {"Mass Markers"};
		browser.link(linkVal).click();
	
	}

	public void acknowledgeTheOrderByChecking() throws Exception {
		String[] checkboxVal = {"ci_responses[Renal risk][chk_ack]"};
		browser.checkbox(checkboxVal).click();
	}
	

	public void releaseBackToWorklistWithouSavingTheOrderInTheList()
			throws Exception {
    String[] submitVal = {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	}
	
	public void selectWorkorderFromTheAvailableOrders() throws Exception {
    String[] selectVal = {"worklist_filter"};
    String[] cellVal= {"Approved"};
		browser.select(selectVal).choose("Ready for Examination");
		browser.cell(cellVal).click();
		browser.waitFor(9000);
	
	}


	public void answerSecurityQuestions() throws Exception {
		String[] radioValPat= {"edit-questions-thisuser-got-patient-response-yes"};
    String[] radioValSite= {"edit-questions-thisuser-got-img-site-response-yes"};
    String[] radioValPos= {"edit-questions-thisuser-set-pat-position-response-yes"};
    String[] radioValPro= {"edit-questions-thisuser-got-img-protocol-response-yes"};
    String[] radioValParams= {"edit-questions-thisuser-set-scnr-params-response-yes"};
		browser.radio(radioValPat).click();
		browser.radio(radioValSite).click();
		browser.radio(radioValPos).click();
		browser.radio(radioValPro).click();
		browser.radio(radioValParams).click();
		Thread.sleep(4000);
	
	}

	public void releaseToWorklistWithoutSaving() throws Exception {
    String[] submitVal= {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectProtocolFromDropdown() throws Exception {
    String[] selectVal= {"protocol1_nm"};
	browser.select(selectVal).choose("CT adrenal mass protocol");
	
	
	}

	public void selectStatusAsReadyForExamination() throws Exception {
    String[] selectVal= {"worklist_filter"};
    browser.select(selectVal).choose("Ready for Examination");
	
	}

	public void selectWorkorderInThisStatus() throws Exception {
    String[] cellVal= {"ONEZEROONEONETHREETWO, PATIENT"};
		browser.cell(cellVal).click();
	
	}

	public void answerSecurityQuestionsInTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-got-patient-response-yes"};
		browser.radio(radioVal).click();
	
	}

	public void selectWorkflowStatusAsReadyForExamination() throws Exception {
    String[] selectVal= {"worklist_filter"};
		browser.select(selectVal).choose("Ready for Examination");
	
	}

	public void selectOrder() throws Exception {
    String[] cellVal= {"ONEZEROONEONETHREETWO, PATIENT"};
		browser.cell(cellVal).click();
	
	}

	public void answerSecurityQuestion1InTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-got-patient-response-yes"};
		browser.radio(radioVal).click();
	}

	public void answerSecurityQuestion2InTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-got-img-site-response-yes"};
		browser.radio(radioVal).click();
	}

	public void answerSecurityQuestion3InTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-set-pat-position-response-yes"};
		browser.radio(radioVal).click();
	}

	public void answerSecurityQuestion4InTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-got-img-protocol-response-yes"};
		browser.radio(radioVal).click();
	
	}

	public void answerSecurityQuestion5InTheForm() throws Exception {
    String[] radioVal= {"edit-questions-thisuser-set-scnr-params-response-yes"};
		browser.radio(radioVal).click();
	
	}

	public void selectRelease() throws Exception {
    String[] submitVal= {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkflowStatusAs(String string1) throws Exception {
		String[] selectVal= {"worklist_filter"};
		browser.select(selectVal).choose(string1);
	
	}

	public void selectOrderWithStatusAs(String string1) throws Exception {
		String[] cellVal= {string1};
		browser.cell(cellVal).click();
		browser.waitFor(9000);	
	}

	public void selectWheterConsentIsReceived() throws Exception {
		String[] radioVal= {"edit-exam-consent-received-kw-yes"};
		browser.radio(radioVal).click();
	
	}

	public void enterNotesInTheTextBox() throws Exception {
	
	}

	public void releaseOrder() throws Exception {
		String[] submitVal= {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkflowStatusAsInterpretation() throws Exception {
		String[] selectVal = {"worklist_filter"};
		browser.select(selectVal).choose("Interpretation");
	
	}

	public void selectTheOrderInThisMode() throws Exception {
    String[] cellVal = {"ELEVEN, PATIENT"};
		browser.cell(cellVal).click();
		browser.waitFor(9000);
	
	}

	public void releaseToWorklist() throws Exception {
    String[] submitVal= {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkflowMode(String string1) throws Exception {
        String[] selectVal = {"worklist_filter"};
		browser.select(selectVal).choose(string1);
	
	}

	public void selectTheOrder(String string1) throws Exception {
        String[] cellVal = {string1};
		browser.cell(cellVal).click();
		browser.waitFor(9000);

	
	}
	
/*	public void enterInterpretationNotesInTheTextBox(String strText) throws Exception {
		Thread.sleep(10000);
		browser.textarea("edit-interpret-notes-tx").exists();
		browser.textarea("edit-interpret-notes-tx").setValue(strText);
		Thread.sleep(5000);
	}
*/
	
	public void releaseToWorklistWithoutSaving1() throws Exception {
		String[] submitVal = {"Release back to Worklist without Saving"};
		browser.submit(submitVal).click();
	
	}

	public void selectWorkflowModeAs(String string1) throws Exception {
		String[] selectVal = {"worklist_filter"};
		browser.select(selectVal).choose(string1);
	
	}

	public void selectOrderForTheList() throws Exception {
		String[] cellVal = {"QA"};
		browser.cell(cellVal).click();
		browser.waitFor(15000);	
	}

	public void answerQAEvaluationQuestions() throws Exception {
	Thread.sleep(9000);
	String[]  labelVal = {"edit-evaluations-sample-qa-question1-score"};
	String[]  radioVal= {"edit-evaluations-sample-qa-question1-score-1"};
	browser.label(labelVal).exists();
	browser.radio(radioVal).exists();
	browser.radio(radioVal).check();
	Thread.sleep(2000);
	browser.radio(radioVal).check();
	Thread.sleep(2000);
	browser.radio(radioVal).check();
	Thread.sleep(2000);
	}

	public void enterInterpretationNotesInTheTextBox(String strNotes) throws Exception {
		String[] textareaVal = {"edit-interpret-notes-tx"};
		browser.textarea(textareaVal).setValue(strNotes);
		Thread.sleep(2000);
	}

		public void openWorkorderFromList() throws Exception {
			String[] cellName = {"Active"};
			browser.cell(cellName).click();
			browser.waitFor(9000); 
		
		}

		public void releaseOrderWithoutSavingToList() throws Exception {
			String[] submitVal = {"Release back to Worklist without Saving"};
			browser.submit(submitVal).click();
		
		}

		public void selectWorkflowModeAsNeedsProtocol() throws Exception {
			String[] workflowMode = {"worklist_filter"};
			browser.select(workflowMode).choose("Needs Protocol");
		
		}

		public void selectProtocolForLibrary() throws Exception {
			String[] labelVal = {"Library"};
			String[] radioVal1= {"tab11"};
			String[] linkVal  = {"select"};
			String[] radioVal2= {"tab1"};

			browser.label(labelVal).click();
			browser.radio(radioVal1).click();
			browser.link(linkVal).click();
			browser.radio(radioVal2).click();
		
		}

		public void selectAllergyOption() throws Exception {
			String[]  radioVal = {"edit-allergy-cd-no--2"};
			browser.radio(radioVal).click();
		
		}

		public void selectClaustrophobicOption() throws Exception {
			String[] radioVal = {"edit-claustrophobic-cd-yes--2"};
			browser.radio(radioVal).click();
		
		}

		public void enterNotesFromList() throws Exception {
			String[] linkVal = {"Emergency"};
			String[] listVal = {"Mass Markers"};
			
			browser.listItem(listVal).click();
			browser.link(linkVal).click();
		
		}

		public void releaseToWorklistWithoutSavingOrder() throws Exception {
			String[] submitVal = {"Release back to Worklist without Saving"};
			browser.submit(submitVal).click();
		
		}

		public void selectWorkorderFromTheeList() throws Exception {
			String[] cellVal = {"CT SCAN"};;
			browser.cell(cellVal).click();
			browser.waitFor(9000);
		
		}

		public void selectMode() throws Exception {
			String[] selectVal = {"worklist_filter"};
			browser.select(selectVal).choose("Needs Protocol");
		
		}

		public void selectOrderFormList() throws Exception {
			String[] orderVal = {"For 2015-04-07 20:15 In RM 120"};
			String[] modalVal = {"administer-modal"};
			browser.link(orderVal).click();
			browser.div(modalVal).click();
		
		}

		public void selectWorkorderFromList() throws Exception {
			String[] cellVal = {"Active"};
			browser.cell(cellVal).click();
			Thread.sleep(9000);
		}

		public void clickOn(String string1) throws Exception {
			String[] replaceVal = {"Cancel Order"};
			//String[] headingVal = {"This order may continue to show up in the worklist until the original order provider signs the discontinuation action."};
			String[] exitVal = {"Exit with No Changes"};
			
			browser.submit(replaceVal).click();
			browser.waitFor(2000);
			//browser.heading2(headingVal).click();
			browser.span(replaceVal).exists();
			browser.waitFor(2000);
			browser.button(exitVal).click();
		
		}

		public void clickOnOnThePage(String string1) throws Exception {
		
		}

		public void clickOnReplaceOrderOnThePage() throws Exception {
			String[] replaceVal = {"raptor-protocol-replace-order-button"};
			//String[] headingVal = {"Your account does not have sufficient VISTA privilege to replace CPRS orders."};
			String[] exitVal = {"Exit with No Changes"};
			browser.waitFor(2000);
			browser.button(replaceVal).click();
			browser.waitFor(2000);
			//browser.heading2(headingVal).click();
			browser.span(replaceVal).exists();
			browser.waitFor(2000);
			browser.button(exitVal).click();
			
		
		}

		public void clickExitWithNoChanges() throws Exception {
		
		}

		public void clickOnColumns() throws Exception {
			String[] columnVal = {"Change Columns"};
			browser.button(columnVal).click();
		
		}

		public void clickRelevantIndicators() throws Exception {
			String[] columnVal = {"column_display"};
			String[] columnVal1 = {"column_display[1]"};
			String[] columnVal2 = {"column_display[2]"};
			String[] columnVal3 = {"column_display[3]"};
			String[] columnVal8 = {"column_display[8]"};

			browser.checkbox(columnVal).click();
			browser.checkbox(columnVal1).click();
			browser.checkbox(columnVal2).click();
			browser.checkbox(columnVal3).click();
			browser.checkbox(columnVal8).click();
		
		}

		public void clickSubmit() throws Exception {
			String[] submitVal = {"Save"};
			browser.button(submitVal).click();
		
		}

		
	
/*	public void answerQAEvaluationQuestions() throws Exception {
		browser.radio("edit-evaluations-sample-qa-question1-score-0").click();
		browser.radio("edit-evaluations-sample-qa-question2-score-1").click();
		browser.radio("edit-evaluations-sample-qa-question3-score-0").click();
		Thread.sleep(4000);
	
	}
*/
	

}